import Content from "./Content";
import { constructMetadata } from "@/components/utils/seo";

const seoData = {
  ar: {
    title: "أخبار ومقالات ..",
    description: "كن على اطلاع دائم على أحدث أخبار شركة السلام، وتقارير المشاريع، والمقالات المتخصصة في قطاع الإنشاء والبناء، مع محتوى يقدّم معرفة عملية ورؤى هندسية موثوقة."
  },
  en: {
    title: "News & Articles ..",
    description: "Stay up to date with the latest news from Al-Salam Company, project reports, and specialized articles in the construction and building sector, featuring practical knowledge and reliable engineering insights."
  }
};


type Props = {
  params: { locale: string }
}

export async function generateMetadata({ params }: Props) {
  const locale = params.locale === 'en' ? 'en' : 'ar';
  const data = seoData[locale];

  return constructMetadata({
    title: data.title,
    description: data.description,
    canonicalUrlRelative: `/${locale}/innovation`,
  });
}

export default function Page() {
  return (
    <Content />
  );
}